using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using JacekMatulewski.Util;

namespace DiskFree_.NET
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			PrzygotujInterfejs();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 268);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.Name = "WinForm";
			this.Text = "DiskFree .NET";
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		/*
		//wersja 1
		private void PrzygotujInterfejs()
		{
			DiskFreeBar dfb=new DiskFreeBar();
			dfb.Location=new Point(10,10);
			dfb.Size=new Size(this.ClientRectangle.Width-2*dfb.Location.X,30);
			dfb.DriveLetter='C';
			dfb.Parent=this;
		}
		*/

		private void PrzygotujInterfejs()
		{
			this.Width=640;
			string[] listaDyskow=System.IO.Directory.GetLogicalDrives();

			//Sprawdzenie czy nosniki sa w napedach
			ArrayList listaDostepnychDyskow=new ArrayList();
			/*
			foreach(string dysk in listaDyskow)
				if (System.IO.Directory.Exists(dysk)) listaDostepnychDyskow.Add(dysk);
			*/
			foreach(string dysk in listaDyskow)
				if (System.IO.Directory.Exists(dysk))
					listaDostepnychDyskow.Add(dysk[0]);

			for(int i=0;i<listaDostepnychDyskow.Count;i++)
				{
				char literaDysku=((char)listaDostepnychDyskow[i]);

				//Pasek
				DiskFreeBar dfb=new DiskFreeBar();
				dfb.Location=new Point(10,30+50*i);
				dfb.Size=new Size(this.ClientRectangle.Width-2*dfb.Location.X,20);
				dfb.DriveLetter=literaDysku;
				dfb.Parent=this;

				//Opis z lewej
				Label opisLewy=new Label();
				opisLewy.AutoSize=true;
				opisLewy.Text=literaDysku+":  "+dfb.DriveVolumeName+"  ("+dfb.DriveFileSystem+", "+dfb.DriveDescription+")";
				opisLewy.Location=new Point(10,10+50*i);
				opisLewy.Parent=this;

				//Opis z prawej
				Label opisPrawy=new Label();
				opisPrawy.AutoSize=true;
				int procent=(int)(100*dfb.DiskOccupiedSpace/dfb.DiskSize);
				opisPrawy.Text=dfb.DiskFreeSpace/1024/1024+" MB / "+dfb.DiskOccupiedSpace/1024/1024+" MB / "+dfb.DiskSize/1024/1024+" MB ("+procent+"%)";
				opisPrawy.Location=new Point(dfb.Location.X+dfb.Size.Width-opisPrawy.Size.Width,10+50*i);
				opisPrawy.Parent=this;
				}

			this.Height=30+50*listaDostepnychDyskow.Count+15;
		}

	}
}
